function [M_x,Mean_x,Std_x]=prepfn(X,preprocessing)
%   Function to perform preprocessing calculation
%   Function: [Mp,mean_x,sm]=prepfn(X,preprocessing)
%   --------------------------------INPUT-------------------------------------------------
%   X               Matrix (n,p), 
%   preprocessing   Preprocessing method for the X and Y method:      
%                   {'none'};
%                   {'mean'};
%                   {'auto'}; 
%                   {'pareto'};
%   --------------------------------OUTPUT------------------------------------------------
%   M_x     Matrix X after processing
%   Mean_x  Mean data of matrix X
%   Std_x   Standard deviation of matrix X (for pareto = sqrt(std(X));)
%
%   This is a part of the GNAT
%   Copyright  2021  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%
%   Hugo da Silva Rocha, PhD Student
%   School of Chemistry, University of Manchester,
%   hugo.rocha@postgrad.manchester.ac.uk

smp=size(X,1);
switch preprocessing
    case 'none'
        M_x=X;
        Mean_x=[];
        Std_x=[];
    case 'mean'
        Mean_x=mean(X);
        Std_x=[];
        M_x=X-repmat(Mean_x, smp, 1);
    case 'auto'
        Mean_x=mean(X);
        Std_x=std(X);
        snzero=1:size(X,2);
        snzero(Std_x==0)=[];
        M_x=zeros(size(X));
        M_x(:,snzero)=(X(:,snzero)-repmat(Mean_x(snzero), smp, 1))./repmat(Std_x(snzero),smp, 1);
    case 'pareto'
        Mean_x=mean(X);
        Std_x=sqrt(std(X));
        snzero=1:size(X,2);
        snzero(Std_x==0)=[];
        M_x=zeros(size(X));
        M_x(:,snzero)=(X(:,snzero)-repmat(Mean_x(snzero), smp, 1))./repmat(Std_x(snzero),smp, 1);
end